﻿//Fichero de cabecera para usar las funciones de distorsion.dll, librería distorsion.lib.
#include <ATcrt/ATsystem.h>
#include "clases_distorsion.h"
#include "Aerotri_defs.h"

#define CAMFORMAT_Aerotri 0
#define CAMFORMAT_ini 1
#define CAMFORMAT_cmr 2
#define CAMFORMAT_RapidCal 3
#define CAMFORMAT_Digi 4
#define CAMFORMAT_Agisfot 5

#ifdef __cplusplus
extern "C"{
#endif
/*lee_ficheroint
params:
	ficheroint: El nombre del fichero a leer
	inm: tipo de fichero.  [0..3] above
	mensaje: ha de ser un char16_t[512] o mayor. Guarda un mensaje de error.
	idioma: Uno de los valores definidos en Aerotri_defs. Se usa sólo para el mensaje de error.
	interna: La estructura se rellena y posteriormente se ha de liberar con free_interna

return:
	0: todo bien;
	AT_NOMEM: No hay memoria;
	otro valor: algún error. En ese caso el mensaje de error se escribe en mensaje
	See the possible values in aerotri_defs.h
*/
/*bfocal, bpp: Solo se aplica a los tipos de fichero *no* de Aerotri. Si se permite
					variar la focal y el punto principal al pasar la distorsión al formato de Aerotri.
					En caso de duda, pasar bfocal=1, bpp=0.
*/
int lee_ficheroint_bfpp(const char16_t* ficheroint, u8int inm, OrientacionInterna* interna, bint bfocal, bint bpp, char16_t* mensaje, u8int idioma);
static inline int lee_ficheroint(const char16_t* ficheroint, u8int inm, OrientacionInterna* interna, char16_t* mensaje, u8int idioma){
	return lee_ficheroint_bfpp(ficheroint,inm,interna,1,0,mensaje,idioma);
}
void free_interna(OrientacionInterna *interna);
/*Para estas funciones mensaje puede ser NULL. Si mensaje no es NULL y se produce un error de escritura se escribe
en mensaje en el idioma indicado. Si no se produce ningún error se devuelve 0.*/
//decim: Cifras decimales para Tx,Ty de afin_1. decf: cifras decimales para la focal y el p.p.
int escribe_ficheroint(const char16_t* ficheroori, const OrientacionInterna *interna, s8int decim, s8int decf, char16_t* mensaje, u8int idioma);
int escribe_ficheroint_cmr(const char16_t* ficheroori, const InternaKPB *kpb, char16_t* mensaje, u8int idioma);
int escribe_ficheroint_Digi(const char16_t* ficheroori, const InternaKPB *kpb, char16_t* mensaje, u8int idioma);
//desplins puede ser NULL.
int escribe_ficheroint_ini(const char16_t* ficheroori, const InternaKPB *kpb, const double desplins[3][3], char16_t* mensaje, u8int idioma);

//Estas dos funciones calculan la distorsión en un punto, de manera que calc+dist=ob.
//Si un punto se transforma mediante las funciones medida_a_fotocoord y fotocoord_a_medida,
//estas dos funciones no hace falta emplearlas para nada.
Puntoxy_float calcula_distorsion(Puntoxy_double* calc, const OrientacionInterna *interna);
Puntoxy_float calcula_distorsion_inversa(Puntoxy_double* ob, const OrientacionInterna *interna);

//Estas dos funciones aplican todos los pasos de la estructura 'interna', en uno u otro sentido
void medida_a_fotocoord(Puntoxy_double* ob, const OrientacionInterna *interna);
void fotocoord_a_medida(Puntoxy_double* ob, const OrientacionInterna *interna);

/*combina_internas
Se supone que las distorsiones de interna2 son pequeñas y que se aplican desde el punto teórico que resulta
de corregir cada fotocoordenada según interna1. De lo contrario la combinación no es exacta.
return:
	0: todo bien
	AT_NOMEM: sin memoria*/
#define CAL_COMBINA_AFIN2		1 //la segunda interna incluye una transformación previa
#define CAL_COMBINA_DISTINTAS	2 //Las relaciones semidiagonal/focal son muy distintas
#define CAL_COMBINA_DISTINTOS_MODELOS	3 //Los modelos polinómicos no coinciden. Aún así las distorsiones se combinan, pero el resultado no es exacto

//combinada se ha de liberar con free_interna
int combina_internas(const OrientacionInterna *interna1, const OrientacionInterna *interna2, OrientacionInterna *combinada);

void elimina_a1(OrientacionInterna *interna);	//Elimina a1. Modifica la focal y semidiag. (y nada más)
void elimina_a1_semidiag(OrientacionInterna *interna);	//Elimina a1 manteniendo la semidiagonal fija.
																	//Como consecuencia todos los demás valores de distorsión varían un poco
void cambia_semidiag(OrientacionInterna *interna, float nuevo);	//Cambia el valor de semidiag. Todos los val. de dist. cambian un poco

/*bfocal: Si se permite varial la focal
bpp: Si se permite mover el punto principal.
	Si no sabe, se recomienda bfocal=0, pbb=1
return: 0, AT_NOMEM
La orientación devuelta habrá que liberarla con free_interna, incluso aunque se devuelva AT_NOMEM*/
int interna_Aerotri___kpb(const InternaKPB *kpb, OrientacionInterna *interna, bint bfocal, bint bpp);

/*
despl: almacena lo que ha sido necesario mover el punto principal debido al paso de {c1,c2,d1,d2} a {p1,p2}.
	Si no es despreciable se pone kpb->inexacta |= 1.
La función puede devolver
	8: No se puede hacer la transformación porque la transformación afin_1 de interna es demasiado compleja
	9: No se puede hacer la transformación porque el modelo polinómico no es impar
  u otro valor que coincidirá entonces con kpb->inexacta. A saber:
	0: correcto
	<8:
		+1: Se ha modificado el punto principal y con ello Ω y Φ no serán iguales
		+2: Existe b2 y por tanto los valores de Kappa no serán iguales
		+4: La transformación es inexacta, se han perdido componentes
*/
int interna_kpb___Aerotri(const OrientacionInterna *interna, InternaKPB *kpb, float *despl);

#ifdef __cplusplus
}
#endif
